-- A Teleport that can be accessed from both sides (left and right or top and bottom)
-- Instruction: see logic "SilentTeleportLine".

function main(self)
	if self.State == 0 then
		self.DrawFlags.NoDraw = true
		self.Flags.AlwaysActive = true
		CreateObject{
			X = self.X,
			Y = self.Y,
			name = "SilentTeleportLine",
			Direction = self.Direction,
			SpeedX = self.SpeedX,
			SpeedY = self.SpeedY,
			Width = self.Width,
			Height = self.Height
		}
		local dir = self.Direction
		local offsetX = (dir == 4 or dir == 6) and 64 or 0 -- 4 is left, 6 is right, like on the num pad
		local offsetY = (dir == 2 or dir == 8) and 64 or 0 -- 2 is down, 8 is up
		CreateObject{
			X = self.SpeedX + offsetX,
			Y = self.SpeedY + offsetY,
			name = "SilentTeleportLine",
			Direction = self.Direction,
			SpeedX = self.X + offsetX,
			SpeedY = self.Y + offsetY,
			Width = self.Width,
			Height = self.Height
		}
		self:Destroy()
	end
end
